import { world } from "@minecraft/server";
import { ModalFormData } from "@minecraft/server-ui";
export const defautConfig = {
    address: "BB18038.local",
    access_token: ""
};
export function getCurrentConfig() {
    let config = world.getDynamicProperty("config");
    if (config === undefined || !(typeof config == "string")) return defautConfig;
    return JSON.parse(config);
}
export function updateConfig(config) {
    world.setDynamicProperty("config", JSON.stringify(config));
}
export async function showConfigUI(player) {
    let current = getCurrentConfig();
    let gui = new ModalFormData().title("Minecraft Fan Remote Config").textField("Local Address:", current.address, current.address).textField("Access Token:", "Access Token", current.access_token ?? undefined);
    let response = await gui.show(player);
    if (response.canceled || !response.formValues) {
        return undefined;
    }
    return {
        address: response.formValues[0],
        access_token: response.formValues[1]
    };
}
